<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplicationAttribute\Show;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Item
 *
 * @Serializer\XmlRoot("item")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplicationAttribute\Show
 */
class Item
{
    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $code;

    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     *
     * @var string
     */
    protected $status;

    /**
     * @Serializer\SerializedName("trackid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("date")
     * @Serializer\Type("DateTime")
     *
     * @var string
     */
    private $date;

    /**
     * @Serializer\SerializedName("attributes")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplicationAttribute\Show\AttributeType>")
     * @Serializer\XmlList(entry="attributeType")
     *
     * @var AttributeType[]
     */
    private $attributeTypes;

    /**
     * @Serializer\SerializedName("error")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplicationAttribute\Show\Errors")
     * @Serializer\XmlList(entry="error")
     *
     * @var Errors
     */
    protected $errors;

    /**
     * Item constructor.
     */
    public function __construct()
    {
        $this->attributeTypes = new ArrayCollection();
    }

    /**
     * @return mixed
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param mixed $status
     * @return Item
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getTrackid()
    {
        return $this->trackId;
    }

    /**
     * @param mixed $trackId
     * @return Item
     */
    public function setTrackid($trackId)
    {
        $this->trackId = $trackId;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param mixed $date
     * @return Item
     */
    public function setDate($date)
    {
        $this->date = $date;

        return $this;
    }

    /**
     * @return AttributeType[]
     */
    public function getAttributeTypes()
    {
        return $this->attributeTypes;
    }

    /**
     * @param AttributeType $attributeType
     * @return Item
     */
    public function addAttributeType($attributeType)
    {
        $this->attributeTypes[] = $attributeType;

        return $this;
    }

    /**
     * @return Errors
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @param Errors $errors
     * @return Item
     */
    public function setErrors(Errors $errors)
    {
        $this->errors = $errors;

        return $this;
    }

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $code
     * @return Item
     */
    public function setCode($code)
    {
        $this->code = $code;
        return $this;
    }
}
