<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplicationRole\Delete;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("userApplicationRoleDelete")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec", "users"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplicationRole\Delete
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("userApplicationRoles")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplicationRole\Delete\UserApplicationRoleType>")
     * @Serializer\XmlList(entry="userApplicationRoleType")
     *
     * @Assert\All({
     *     @Assert\NotBlank
     * })
     *
     * @var UserApplicationRoleType[]|ArrayCollection
     */
    protected $userApplicationRoleType;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->userApplicationRoleType = new ArrayCollection();
    }

    /**
     * @return UserApplicationRoleType[]|ArrayCollection
     */
    public function getUserApplicationRoleType()
    {
        return $this->userApplicationRoleType;
    }

    /**
     * @param UserApplicationRoleType $userApplicationRoleType
     */
    public function addUserApplicationRoleType(UserApplicationRoleType $userApplicationRoleType)
    {
        if (!$this->userApplicationRoleType->contains($userApplicationRoleType)) {
            $this->userApplicationRoleType->add($userApplicationRoleType);
        }
    }
}
