<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserService\ActivateConfirm;

use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserService\ActivateConfirm
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return Response
     */
    public function response()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Response();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserType
     */
    public function userType()
    {
        return new UserType();
    }

    /**
     * @return ErrorCollector\Error
     */
    public function error()
    {
        return new ErrorCollector\Error();
    }
}
