<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserService\ActivateRequest;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("userServiceActivateRequest")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserService\ActivateRequest
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("userActivateRequest")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserService\ActivateRequest\UserType>")
     * @Serializer\XmlList(entry="userType")
     *
     * @var UserType[]|ArrayCollection
     */
    private $userTypes;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->userTypes = new ArrayCollection();
    }

    /**
     * @return UserType[]|ArrayCollection
     */
    public function getUserTypes()
    {
        return $this->userTypes;
    }

    /**
     * @param UserType $userType
     *
     * @return $this
     */
    public function addUserType(UserType $userType)
    {
        if (!$this->userTypes->contains($userType)) {
            $this->userTypes->add($userType);
        }

        return $this;
    }
}
