<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserService\ActivateRequest;

use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error;
use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 *
 * @Serializer\XmlRoot("userType")
 * @Serializer\AccessorOrder("custom", custom={"code","status"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplication\Add
 */
class UserType
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("username")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("email")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $email;

    /**
     * @Serializer\SerializedName("activateToken")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $activateToken;

    /**
     * @Serializer\SerializedName("activateTokenExpire")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $activateTokenExpire;
    /**
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error>")
     * @Serializer\XmlList(entry="error")
     *
     * @var Error[]|ArrayCollection
     */
    private $errors;

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     *
     * @return UserType
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     *
     * @return UserType
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return string
     */
    public function getActivateToken()
    {
        return $this->activateToken;
    }

    /**
     * @param string $activateToken
     *
     * @return UserType
     */
    public function setActivateToken($activateToken)
    {
        $this->activateToken = $activateToken;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getActivateTokenExpire()
    {
        return $this->activateTokenExpire;
    }

    /**
     * @param \DateTime $activateTokenExpire
     *
     * @return UserType
     */
    public function setActivateTokenExpire($activateTokenExpire)
    {
        $this->activateTokenExpire = $activateTokenExpire;

        return $this;
    }

    /**
     * @return Error[]|ArrayCollection
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @param Error $error
     * @return UserType
     */
    public function addError(Error $error)
    {
        if (!$this->errors) {
            $this->errors = new ArrayCollection();
        }

        if (!$this->errors->contains($error)) {
            $this->errors->add($error);
        }

        return $this;
    }
}
