<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\Show;

use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("userApplication")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\Show
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("userApplications")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\Show\UserApplication")
     *
     * @var UserApplication
     */
    private $userApplication;

    /**
     * @return UserApplication
     */
    public function getUserApplication()
    {
        return $this->userApplication;
    }

    /**
     * @param UserApplication $userApplication
     * @return Response
     */
    public function setUserApplication(UserApplication $userApplication)
    {
        $this->userApplication = $userApplication;

        return $this;
    }
}
