<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\Show;

use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error;
use Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\Show\Success\UserType as XmlUserType;
use Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\Show\Success\ApplicationType as XmlApplicationType;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserApplication
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\Show
 */
class UserApplication
{
    /**
     * @Serializer\SerializedName("userType")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\Show\UserType")
     *
     * @var UserType
     */
    private $userType;

    /**
     * @Serializer\SerializedName("applicationType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\Show\ApplicationType>")
     * @Serializer\XmlList(inline=true, entry="applicationType")
     *
     * @var ApplicationType
     */
    private $applicationType;

    /**
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error>")
     * @Serializer\XmlList(entry="error")
     *
     * @var Error[]|ArrayCollection
     */
    private $error;

    /**
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType $userType
     * @return UserApplication
     */
    public function setUserType($userType = null)
    {
        // Fix for Sso\RestBundle\Api\Helper\Mapper
        if (!empty($userType)) {
            if ($userType instanceof XmlUserType) {
                $restUserType = new UserType();

                $restUserType
                    ->setCode(200);
                $restUserType
                    ->setGuid($userType->getGuid())
                    ->setEmail($userType->getEmail())
                    ->setUsername($userType->getUsername())
                    ->setFirstName($userType->getFirstName())
                    ->setLastName($userType->getLastName())
                    ->setActive($userType->getActive())
                    ->setAuthId($userType->getAuthId())
                    ->setLdapSearchAttributes($userType->getLdapSearchAttributes())
                    ->setLdapSearchValue($userType->getLdapSearchValue());;
                $restUserType
                    ->setDeleted($userType->getDeleted())
                    ->setCreatedAt($userType->getCreatedAt())
                    ->setUpdatedAt($userType->getUpdatedAt())
                    ->setMfaEnabled($userType->getMfaEnabled());

                $this->userType = $restUserType;
            } else {
                $this->userType = $userType;
            }
        }

        return $this;
    }

    /**
     * @return ApplicationType
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @param ApplicationType[]|ArrayCollection $applicationType
     * @return UserApplication
     */
    public function setApplicationType($applicationType = null)
    {
        // Fix for Sso\RestBundle\Api\Helper\Mapper
        if (!empty($applicationType)) {
            $restApplicationType = new ArrayCollection();

            foreach ($applicationType as $type) {
                if ($type instanceof XmlApplicationType) {
                    $restType = new ApplicationType();

                    $restType
                        ->setName($type->getName())
                        ->setActive($type->getActive());

                    if (!$restApplicationType->contains($restType)) {
                        $restApplicationType->add($restType);
                    }
                } else {
                    if (!$restApplicationType->contains($type)) {
                        $restApplicationType->add($type);
                    }
                }
            }

            // prevent empty array in response
            if (!$restApplicationType->isEmpty()) {
                $this->applicationType = $restApplicationType;
            }
        }

        return $this;
    }

    /**
     * @return Error[]|ArrayCollection
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * @param Error $error
     * @return UserApplication
     */
    public function setError(Error $error)
    {
        // Prevent empty error array in success response
        if (!$this->error) {
            $this->error = new ArrayCollection();
        }

        if (!$this->error->contains($error)) {
            $this->error->add($error);
        }

        return $this;
    }
}
