<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\ShowDetails\Error;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 * @package Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\ShowDetails\Error
 */
class UserType
{
    /**
     * @Serializer\SerializedName("guid")
     * @Serializer\Type("string")
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("sessionLifeTime")
     * @Serializer\Type("string")
     */
    private $sessionLifeTime;

    /**
     * @Serializer\SerializedName("userToken")
     * @Serializer\Type("string")
     */
    private $userIdentifier;

    /**
     * @Serializer\SerializedName("username")
     * @Serializer\Type("string")
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("email")
     * @Serializer\Type("string")
     * @var string
     */
    private $email;

    /**
     * @Serializer\SerializedName("firstname")
     * @Serializer\Type("string")
     * @var string
     */
    private $firstname;

    /**
     * @Serializer\SerializedName("lastname")
     * @Serializer\Type("string")
     * @var string
     */
    private $lastname;

    /**
     * @Serializer\SerializedName("active")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(getter="getActiveAsInteger")
     * @var boolean
     */
    private $active;

    /**
     * @Serializer\SerializedName("deleted")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(getter="getDeletedAsInteger")
     * @var boolean
     */
    private $deleted;

    /**
     * @Serializer\SerializedName("createdAt")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @Serializer\SerializedName("updatedAt")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @Serializer\SerializedName("lastLoginAt")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $lastLoginAt;

    /**
     * @Serializer\SerializedName("authId")
     * @Serializer\Type("string")
     * @var string
     */
    private $authId;

    /**
     * @Serializer\SerializedName("ldapSearchAttributes")
     * @Serializer\Type("string")
     * @var string
     */
    private $ldapSearchAttributes;

    /**
     * @Serializer\SerializedName("ldapSearchValue")
     * @Serializer\Type("string")
     * @var string
     */
    private $ldapSearchValue;

    /**
     * @Serializer\SerializedName("mfaEnabled")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(getter="getMfaEnabledAsInteger")
     * @var boolean
     */
    private $mfaEnabled;

    /**
     * @param mixed $sessionLifeTime
     * @return UserType
     */
    public function setSessionLifeTime($sessionLifeTime)
    {
        $this->sessionLifeTime = $sessionLifeTime;
        return $this;
    }

    /**
     * @param mixed $userToken
     * @return UserType
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->userIdentifier = $userIdentifier;
        return $this;
    }

    /**
     * @param string $guid
     * @return UserType
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
        return $this;
    }

    /**
     * @param string $username
     * @return UserType
     */
    public function setUsername($username)
    {
        $this->username = $username;
        return $this;
    }

    /**
     * @param string $email
     * @return UserType
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @param string $firstname
     * @return UserType
     */
    public function setFirstname($firstname)
    {
        $this->firstname = $firstname;
        return $this;
    }

    /**
     * @param string $lastname
     * @return UserType
     */
    public function setLastname($lastname)
    {
        $this->lastname = $lastname;
        return $this;
    }

    /**
     * @param boolean $active
     * @return UserType
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }

    /**
     * @return integer
     */
    public function getActiveAsInteger()
    {
        return $this->active ? 1 : 0;
    }

    /**
     * @param boolean $deleted
     * @return UserType
     */
    public function setDeleted($deleted)
    {
        $this->deleted = $deleted;
        return $this;
    }

    /**
     * @return integer
     */
    public function getDeletedAsInteger()
    {
        return $this->deleted ? 1 : 0;
    }

    /**
     * @param \DateTime $createdAt
     * @return UserType
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;
        return $this;
    }

    /**
     * @param \DateTime $lastLoginAt
     * @return UserType
     */
    public function setLastLoginAt($lastLoginAt)
    {
        $this->lastLoginAt = $lastLoginAt;
        return $this;
    }

    /**
     * @param \DateTime $updatedAt
     * @return UserType
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;
        return $this;
    }

    /**
     * @param string $authId
     * @return UserType
     */
    public function setAuthId($authId)
    {
        $this->authId = $authId;
        return $this;
    }

    /**
     * @param string $ldapSearchAttributes
     * @return UserType
     */
    public function setLdapSearchAttributes($ldapSearchAttributes)
    {
        $this->ldapSearchAttributes = $ldapSearchAttributes;
        return $this;
    }

    /**
     * @param string $ldapSearchValue
     * @return UserType
     */
    public function setLdapSearchValue($ldapSearchValue)
    {
        $this->ldapSearchValue = $ldapSearchValue;
        return $this;
    }

    /**
     * @param boolean $mfaEnabled
     * @return UserType
     */
    public function setMfaEnabled($mfaEnabled)
    {
        $this->mfaEnabled = $mfaEnabled;
        return $this;
    }

    /**
     * @return integer
     */
    public function getMfaEnabledAsInteger()
    {
        return $this->mfaEnabled ? 1 : 0;
    }
}
