<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\ShowDetails\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 *
 * Class ApplicationType
 * @package Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Response\Version2
 */
final class ApplicationType
{
    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("active")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $active;

    /**
     * @Serializer\SerializedName("attributeType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\ShowDetails\Success\AttributeType>")
     * @Serializer\XmlList(inline=true, entry="attributeType")
     * @var AttributeType[]
     */
    private $attributeType;

    /**
     * @Serializer\SerializedName("applicationRoleType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\ShowDetails\Success\ApplicationRoleType>")
     * @Serializer\XmlList(inline=true, entry="applicationRoleType")
     * @var ApplicationRoleType[]
     */
    private $applicationRoleType;

    /**
     * ApplicationType constructor.
     */
    public function __construct()
    {
        $this->attributeType = new ArrayCollection();
        $this->applicationRoleType = new ArrayCollection();

    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ApplicationType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return integer
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @param integer $active
     * @return ApplicationType
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * @param AttributeType[] $attributeType
     * @return ApplicationType
     */
    public function addAttributeType(AttributeType $attributeType)
    {
        if (!$this->attributeType->contains($attributeType)) {
            $this->attributeType->add($attributeType);
        }
        return $this;
    }

    /**
     * @param ApplicationRoleType[] $applicationRoleType
     * @return ApplicationType
     */
    public function addApplicationRoleType(ApplicationRoleType $applicationRoleType)
    {
        if (!$this->applicationRoleType->contains($applicationRoleType)) {
            $this->applicationRoleType->add($applicationRoleType);
        }
        return $this;
    }

    /**
     * @return AttributeType[]
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }

    /**
     * @return ApplicationRoleType[]
     */
    public function getApplicationRoleType()
    {
        return $this->applicationRoleType;
    }
}
