<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\ShowDetails\Success;

/**
 * Class Factory
 * @package Sso\RestBundle\ModelRest\Response\UserWs\UserApplication\ShowDetails
 */
class Factory
{
    /**
     * @var array
     */
    private $facSetter;

    /**
     * @return Response
     */
    public function response()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Response();
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ApplicationRoleType
     */
    public function applicationRoleType()
    {
        return new ApplicationRoleType();
    }

    /**
     * @return ApplicationType
     */
    public function applicationType()
    {
        return new ApplicationType();
    }

    /**
     * @return AttributeType
     */
    public function attributeType()
    {
        return new AttributeType();
    }

    /**
     * @return UserType
     */
    public function userType()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserType();
        }

        return $this->facSetter[__FUNCTION__];
    }
}
