<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\ShowDetails\Success;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use DateTime;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("userApplicationShowDetails")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "message", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\UserApplication\ShowDetails
 */
class Response
{
    /**
     * include trait header
     */
    use ResponseHead;

    /**
     * @Serializer\SerializedName("userType")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\ShowDetails\Success\UserType")
     * @var UserType
     */
    private $userType;

    /**
     * @Serializer\SerializedName("applicationType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\ShowDetails\Success\ApplicationType>")
     * @Serializer\XmlList(inline=true,entry="applicationType")
     * @var ApplicationType[]
     */
    private $applicationType;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->date = new DateTime();
        $this->applicationType = new ArrayCollection();
    }


    /**
     * @param ApplicationType $applicationType
     * @return $this
     */
    public function addApplicationType(ApplicationType $applicationType)
    {
        if (!$this->applicationType->contains($applicationType)) {
            $this->applicationType->add($applicationType);
        }

        return $this;
    }


    /**
     * @param UserType $userType
     * @return $this
     */
    public function setUserType(UserType $userType)
    {
        $this->userType = $userType;

        return $this;
    }

    /**
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @return ApplicationType[]
     */
    public function getApplicationTypes()
    {
        return $this->applicationType;
    }
}
