<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplication\ShowDetails\Success;

use JMS\Serializer\Annotation as Serializer;
use DateTime;

/**
 * Class UserStatus
 *
 * @Serializer\XmlRoot("userStatus")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\UserApplication\ShowDetails
 */
class UserStatus
{
    /**
     * @Serializer\SerializedName("loginStatus")
     * @Serializer\Type("string")
     * @var string
     */
    private $loginStatus;

    /**
     * @Serializer\SerializedName("userIdentifier")
     * @Serializer\Type("string")
     * @var string
     */
    private $userIdentifier;

    /**
     * @Serializer\SerializedName("sessionLifeTime")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $sessionLifeTime;

    /**
     * @param string $loginStatus
     * @return UserStatus
     */
    public function setLoginStatus($loginStatus)
    {
        $this->loginStatus = $loginStatus;

        return $this;
    }

    /**
     * @param string $userIdentifier
     * @return UserStatus
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->userIdentifier = $userIdentifier;

        return $this;
    }

    /**
     * @param DateTime $sessionLifeTime
     * @return UserStatus
     */
    public function setSessionLifeTime(DateTime $sessionLifeTime)
    {
        $this->sessionLifeTime = $sessionLifeTime;

        return $this;
    }
}
