<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationAttribute\Show;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class ApplicationType
 *
 * @Serializer\XmlRoot("userType")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationAttribute\Show
 */
class ApplicationType
{
    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("active")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $active;

    /**
     * @Serializer\SerializedName("applicationAttribute")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationAttribute\Show\ApplicationAttribute>")
     * @Serializer\XmlList(inline=true,entry="applicationAttribute")
     *
     * @var ApplicationAttribute[]|ArrayCollection
     */
    private $applicationAttribute;

    /**
     * ApplicationType constructor.
     */
    public function __construct()
    {
        $this->applicationAttribute = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ApplicationType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return int
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param int $active
     * @return ApplicationType
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * @return ApplicationAttribute[]|ArrayCollection
     */
    public function getApplicationAttribute()
    {
        return $this->applicationAttribute;
    }

    /**
     * @param ApplicationAttribute $applicationAttribute
     * @return ApplicationType
     */
    public function setApplicationAttribute(ApplicationAttribute $applicationAttribute)
    {
        if (!$this->applicationAttribute->contains($applicationAttribute)) {
            $this->applicationAttribute->add($applicationAttribute);
        }

        return $this;
    }
}
