<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationRole\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Error
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationRole\Show
 */
class Error
{
    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("int")
     *
     * @var int
     */
    private $code;

    /**
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $message;

    /**
     * @Serializer\SerializedName("exception")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $exception;

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $code
     * @return Error
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $message
     * @return Error
     */
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }

    /**
     * @return string
     */
    public function getException()
    {
        return $this->exception;
    }

    /**
     * @param string $exception
     *
     * @return Error
     */
    public function setException($exception)
    {
        $this->exception = $exception;

        return $this;
    }
}
