<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationRole\Show;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationRole\Show
 */
class UserType
{
    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $code;

    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     *
     * @var integer
     */
    private $status;

    /**
     * @Serializer\SerializedName("guid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $guid;

    /**
     * @Serializer\SerializedName("username")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $username;

    /**
     * @Serializer\SerializedName("email")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $email;

    /**
     * @Serializer\SerializedName("firstname")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $firstName;

    /**
     * @Serializer\SerializedName("lastname")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $lastName;

    /**
     * @Serializer\SerializedName("active")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $active;

    /**
     * @Serializer\SerializedName("deleted")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $deleted;

    /**
     * @Serializer\SerializedName("createdAt")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @Serializer\SerializedName("lastLoginAt")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $lastLoginAt;

    /**
     * @Serializer\SerializedName("updatedAt")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @Serializer\SerializedName("authId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $authId;

    /**
     * @Serializer\SerializedName("ldapSearchAttributes")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $ldapSearchAttributes;

    /**
     * @Serializer\SerializedName("ldapSearchValue")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $ldapSearchValue;

    /**
     * @Serializer\SerializedName("mfaEnabled")
     * @Serializer\Type("string")
     * @var string
     */
    private $mfaEnabled;

    /**
     * @Serializer\SerializedName("applicationType")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationRole\Show\ApplicationType")
     *
     * @var ApplicationType
     */
    protected $applicationType;

    /**
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationRole\Show\Error>")
     * @Serializer\XmlList(entry="error")
     *
     * @var Error[]|ArrayCollection
     */
    private $errors;

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @param string $guid
     *
     * @return $this
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;

        return $this;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     *
     * @return $this
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     *
     * @return $this
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @param string $firstName
     *
     * @return $this
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;

        return $this;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @param string $lastName
     *
     * @return $this
     */
    public function setLastName($lastName)
    {
        $this->lastName = $lastName;

        return $this;
    }

    /**
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param string $active
     *
     * @return $this
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * @return string
     */
    public function getDeleted()
    {
        return $this->deleted;
    }

    /**
     * @param string $deleted
     * @return UserType
     */
    public function setDeleted($deleted)
    {
        $this->deleted = $deleted;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastLoginAt()
    {
        return $this->lastLoginAt;
    }

    /**
     * @param \DateTime $lastLoginAt
     * @return UserType
     */
    public function setLastLoginAt($lastLoginAt)
    {
        $this->lastLoginAt = $lastLoginAt;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @param \DateTime $updatedAt
     * @return UserType
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * @return string
     */
    public function getAuthId()
    {
        return $this->authId;
    }

    /**
     * @param string $authId
     * @return UserType
     */
    public function setAuthId($authId)
    {
        $this->authId = $authId;

        return $this;
    }

    /**
     * @return string
     */
    public function getLdapSearchAttributes()
    {
        return $this->ldapSearchAttributes;
    }

    /**
     * @param string $ldapSearchAttributes
     * @return UserType
     */
    public function setLdapSearchAttributes($ldapSearchAttributes)
    {
        $this->ldapSearchAttributes = $ldapSearchAttributes;
        return $this;
    }

    /**
     * @return string
     */
    public function getLdapSearchValue()
    {
        return $this->ldapSearchValue;
    }

    /**
     * @param string $ldapSearchValue
     * @return UserType
     */
    public function setLdapSearchValue($ldapSearchValue)
    {
        $this->ldapSearchValue = $ldapSearchValue;
        return $this;
    }

    /**
     * @return string
     */
    public function getMfaEnabled()
    {
        return $this->mfaEnabled;
    }

    /**
     * @param string $mfaEnabled
     * @return UserType
     */
    public function setMfaEnabled($mfaEnabled)
    {
        $this->mfaEnabled = $mfaEnabled;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @param \DateTime $createdAt
     * @return UserType
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;
        return $this;
    }

    /**
     * @return ApplicationType
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @param ApplicationType $applicationType
     *
     * @return $this
     */
    public function setApplicationType($applicationType)
    {
        $this->applicationType = $applicationType;

        return $this;
    }

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $code
     *
     * @return UserType
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param int $status
     *
     * @return UserType
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Error[]|ArrayCollection
     */
    public function getError()
    {
        return $this->errors;
    }

    /**
     * @param Error $error
     * @return UserType
     */
    public function setError(Error $error)
    {
        // Prevent empty error array in success response
        if (!$this->errors) {
            $this->errors = new ArrayCollection();
        }

        if (!$this->errors->contains($error)) {
            $this->errors->add($error);
        }

        return $this;
    }
}
