<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\FindByApplication;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("userSearchByApplication")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\FindByApplication
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("userByApplication")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\FindByApplication\UserByApplication")
     *
     * @var UserByApplication
     */
    private $userByApplication;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->userByApplication = new UserByApplication();
    }

    /**
     * @return UserByApplication
     */
    public function getUserByApplication()
    {
        return $this->userByApplication;
    }

    /**
     * @param UserByApplication $userByApplication
     * @return Response
     */
    public function setUserByApplication(UserByApplication $userByApplication)
    {
        $this->userByApplication = $userByApplication;

        return $this;
    }
}
