<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelShared\Response\UserWs\Version2\UserSearch\Advanced\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 * @package Sso\WebserviceBundle\Services\UserSearch\Advanced\Response\Version2\Success
 */
final class UserType
{
    /**
     * @Serializer\SerializedName("Guid")
     * @Serializer\Type("string")
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("Username")
     * @Serializer\Type("string")
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("Email")
     * @Serializer\Type("string")
     * @var string
     */
    private $email;

    /**
     * @Serializer\SerializedName("Firstname")
     * @Serializer\Type("string")
     * @var string
     */
    private $firstname;

    /**
     * @Serializer\SerializedName("Lastname")
     * @Serializer\Type("string")
     * @var string
     */
    private $lastname;

    /**
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(getter="getActiveAsInteger")
     * @var boolean
     */
    private $active;

    /**
     * @Serializer\SerializedName("Deleted")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(getter="getDeletedAsInteger")
     * @var boolean
     */
    private $deleted;

    /**
     * @Serializer\SerializedName("CreatedAt")
     * @Serializer\Type("DateTime<'Y-m-d\TH:i:sP'>")
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @Serializer\SerializedName("UpdatedAt")
     * @Serializer\Type("DateTime<'Y-m-d\TH:i:sP'>")
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @Serializer\SerializedName("LastLoginAt")
     * @Serializer\Type("DateTime<'Y-m-d\TH:i:sP'>")
     * @var \DateTime
     */
    private $lastLoginAt;

    /**
     * @Serializer\SerializedName("AuthId")
     * @Serializer\Type("string")
     * @var string
     */
    private $authId;

    /**
     * @Serializer\SerializedName("LdapSearchAttributes")
     * @Serializer\Type("string")
     * @var string
     */
    private $ldapSearchAttributes;

    /**
     * @Serializer\SerializedName("LdapSearchValue")
     * @Serializer\Type("string")
     * @var string
     */
    private $ldapSearchValue;

    /**
     * @Serializer\SerializedName("MfaEnabled")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(getter="getMfaEnabledAsInteger")
     * @var boolean
     */
    private $mfaEnabled;

    /**
     * @param array $userAttributes
     * @return UserType
     */
    public function setFromArray(array $userAttributes)
    {
        foreach ($userAttributes as $name => $value) {
            $method = 'set' . ucfirst($name);
            if (!method_exists($this, $method)) {
                throw new \BadMethodCallException(sprintf(
                    'Unable to create user response model %s! Userattribute % does not exist.',
                    self::class,
                    $name
                ));
            }
            $this->$method($value);
        }
    }

    /**
     * @param string $guid
     * @return UserType
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
        return $this;
    }

    /**
     * @param string $username
     * @return UserType
     */
    public function setUsername($username)
    {
        $this->username = $username;
        return $this;
    }

    /**
     * @param string $email
     * @return UserType
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @param string $firstname
     * @return UserType
     */
    public function setFirstname($firstname)
    {
        $this->firstname = $firstname;
        return $this;
    }

    /**
     * @param string $lastname
     * @return UserType
     */
    public function setLastname($lastname)
    {
        $this->lastname = $lastname;
        return $this;
    }

    /**
     * @param boolean $active
     * @return UserType
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }

    /**
     * @return integer
     */
    public function getActiveAsInteger()
    {
        return $this->active ? 1 : 0;
    }

    /**
     * @param boolean $deleted
     * @return UserType
     */
    public function setDeleted($deleted)
    {
        $this->deleted = $deleted;
        return $this;
    }

    /**
     * @return integer
     */
    public function getDeletedAsInteger()
    {
        return $this->deleted ? 1 : 0;
    }

    /**
     * @param \DateTime $createdAt
     * @return UserType
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;
        return $this;
    }

    /**
     * @param \DateTime $lastLoginAt
     * @return UserType
     */
    public function setLastLoginAt($lastLoginAt)
    {
        $this->lastLoginAt = $lastLoginAt;
        return $this;
    }

    /**
     * @param \DateTime $updatedAt
     * @return UserType
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;
        return $this;
    }

    /**
     * @param string $authId
     * @return UserType
     */
    public function setAuthId($authId)
    {
        $this->authId = $authId;
        return $this;
    }

    /**
     * @param string $ldapSearchAttributes
     * @return UserType
     */
    public function setLdapSearchAttributes($ldapSearchAttributes)
    {
        $this->ldapSearchAttributes = $ldapSearchAttributes;
        return $this;
    }

    /**
     * @param string $ldapSearchValue
     * @return UserType
     */
    public function setLdapSearchValue($ldapSearchValue)
    {
        $this->ldapSearchValue = $ldapSearchValue;
        return $this;
    }

    /**
     * @param boolean $mfaEnabled
     * @return UserType
     */
    public function setMfaEnabled($mfaEnabled)
    {
        $this->mfaEnabled = $mfaEnabled;
        return $this;
    }

    /**
     * @return integer
     */
    public function getMfaEnabledAsInteger()
    {
        return $this->mfaEnabled ? 1 : 0;
    }

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @return string
     */
    public function getFirstname()
    {
        return $this->firstname;
    }

    /**
     * @return string
     */
    public function getLastname()
    {
        return $this->lastname;
    }

    /**
     * @return bool
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @return bool
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @return \DateTime
     */
    public function getLastLoginAt()
    {
        return $this->lastLoginAt;
    }

    /**
     * @return string
     */
    public function getAuthId()
    {
        return $this->authId;
    }

    /**
     * @return string
     */
    public function getLdapSearchAttributes()
    {
        return $this->ldapSearchAttributes;
    }

    /**
     * @return string
     */
    public function getLdapSearchValue()
    {
        return $this->ldapSearchValue;
    }

    /**
     * @return bool
     */
    public function isMfaEnabled()
    {
        return $this->mfaEnabled;
    }
}
