<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Credentials
 *
 * @Serializer\XmlRoot("Credentials")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs
 */
class Credentials
{
    /**
     * @Serializer\SerializedName("ServiceProvider")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\ServiceProvider")
     * @var ServiceProvider
     */
    protected $serviceProvider;

    /**
     * @Serializer\SerializedName("ServiceTrigger")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\ServiceTrigger")
     * @var ServiceTrigger
     */
    protected $serviceTrigger;

    /**
     * @Serializer\SerializedName("ServiceCountry")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\ServiceCountry")
     * @var ServiceCountry
     */
    protected $serviceCountry;

    /**
     *
     * @param ServiceProvider $serviceProvider
     */
    public function addServiceProvider(ServiceProvider $serviceProvider)
    {
        $this->serviceProvider = $serviceProvider;
    }

    /**
     *
     * @return ServiceProvider
     */
    public function getServiceProvider()
    {
        return $this->serviceProvider;
    }

    /**
     *
     * @param ServiceTrigger $serviceTrigger
     */
    public function addServiceTrigger(ServiceTrigger $serviceTrigger)
    {
        $this->serviceTrigger = $serviceTrigger;
    }

    /**
     *
     * @return ServiceTrigger
     */
    public function getServiceTrigger()
    {
        return $this->serviceTrigger;
    }

    /**
     *
     * @param ServiceCountry $serviceCountry
     */
    public function addServiceCountry(ServiceCountry $serviceCountry)
    {
        $this->serviceCountry = $serviceCountry;
    }

    /**
     *
     * @return ServiceCountry
     */
    public function getServiceCountry()
    {
        return $this->serviceCountry;
    }

    /**
     *
     * @param string $serviceToken
     * @param string $serviceName
     * @param string $userIdentifier
     * @param string $userName
     * @param string $code
     */
    public function setCredentialsData($serviceToken, $serviceName, $userIdentifier, $userName, $code)
    {

        $serviceProvider = new ServiceProvider();
        $serviceProvider->setServiceToken($serviceToken);
        $serviceProvider->setServiceName($serviceName);
        $this->addServiceProvider($serviceProvider);

        $serviceTrigger = new ServiceTrigger();
        $serviceTrigger->setUserIdentifier($userIdentifier);
        $serviceTrigger->setUsername($userName);
        $this->addServiceTrigger($serviceTrigger);

        $serviceCountry = new ServiceCountry();
        $serviceCountry->setCode($code);
        $this->addServiceCountry($serviceCountry);
    }
}
