<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\IdpWs\ServiceUser\Get;

use JMS\Serializer\Annotation as Serializer;
use Sso\Tools\UserIdentifierBundle\Model\Request\Node;

/**
 * Steps GetAction
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Get
{
    /**
     * @Serializer\SerializedName("Key")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\IdpWs\ServiceUser\Get\Key")
     * @var Node\Key
     */
    private $key;


    public function __construct($username, $password)
    {
        $this->key = new Key($username, $password);
    }
}
