<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\IdpWs\ServiceUser\Validate;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 * @package Sso\RestBundle\ModelXml\Request\IdpWs\ServiceUser\Validate
 */
class UserType
{
    /**
     * @Serializer\SerializedName("Username")
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("UserIdentifier")
     * @var string
     */
    private $userIdentifier;

    /**
     *
     * @param string $username
     * @param string $userIdentifier
     */
    public function __construct($username, $userIdentifier)
    {
        $this->username = $username;
        $this->userIdentifier = $userIdentifier;
    }
}
