<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Attribute\Add;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class AttributeType
 *
 * @Serializer\XmlRoot("Add")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Attribute\Add
 */
class AttributeType
{
    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $attributeName;

    /**
     * @Serializer\SerializedName("Mandatory")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $attributeMandatory;

    /**
     * @Serializer\SerializedName("PossibleValues")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(entry="Value")
     *
     * @var ArrayCollection|string[]
     */
    private $attributePossibleValues;

    /**
     * @Serializer\SerializedName("DefaultValue")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $attributeDefaultValue;

    /**
     * @Serializer\SerializedName("Translatable")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $attributeTranslatable;

    /**
     * @Serializer\SerializedName("GroupId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $attributeGroupId;

    /**
     * @return string
     */
    public function getAttributeName()
    {
        return $this->attributeName;
    }

    /**
     * @param string $attributeName
     * @return AttributeType
     */
    public function setAttributeName($attributeName)
    {
        $this->attributeName = $attributeName;
        return $this;
    }

    /**
     * @return int
     */
    public function getAttributeMandatory()
    {
        return $this->attributeMandatory;
    }

    /**
     * @param int $attributeMandatory
     * @return AttributeType
     */
    public function setAttributeMandatory($attributeMandatory)
    {
        $this->attributeMandatory = $attributeMandatory;
        return $this;
    }

    /**
     * @return ArrayCollection|string[]
     */
    public function getAttributePossibleValues()
    {
        return $this->attributePossibleValues;
    }

    /**
     * @param string $attributePossibleValue
     * @return AttributeType
     */
    public function setAttributePossibleValue($attributePossibleValue)
    {
        if (!$this->attributePossibleValues) {
            $this->attributePossibleValues = new ArrayCollection();
        }

        if (!$this->attributePossibleValues->contains($attributePossibleValue)) {
            $this->attributePossibleValues->add($attributePossibleValue);
        }

        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeDefaultValue()
    {
        return $this->attributeDefaultValue;
    }

    /**
     * @param string $attributeDefaultValue
     * @return AttributeType
     */
    public function setAttributeDefaultValue($attributeDefaultValue)
    {
        $this->attributeDefaultValue = $attributeDefaultValue;
        return $this;
    }

    /**
     * @return int
     */
    public function getAttributeTranslatable()
    {
        return $this->attributeTranslatable;
    }

    /**
     * @param int $attributeTranslatable
     * @return AttributeType
     */
    public function setAttributeTranslatable($attributeTranslatable)
    {
        $this->attributeTranslatable = $attributeTranslatable;
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeGroupId()
    {
        return $this->attributeGroupId;
    }

    /**
     * @param string $attributeGroupId
     * @return AttributeType
     */
    public function setAttributeGroupId($attributeGroupId)
    {
        $this->attributeGroupId = $attributeGroupId;
        return $this;
    }
}
