<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Add;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class AttributeGroup
 *
 * @Serializer\XmlRoot("Credentials")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Add
 */
class AttributeGroup
{
    /**
     * @Serializer\SerializedName("Add")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Add\Add")
     *
     * @var Add
     */
    private $add;

    /**
     * @param string $name
     * @param ArrayCollection|null $ids
     */
    public function setAttributeGroup($name, $ids = null)
    {
        $types = new ArrayCollection();
        if (null !== $ids) {
            foreach ($ids as $id) {
                $type = new Type();
                $type->setId($id);
                $types->add($type);
            }
        }

        $attributeGroupType = new AttributeGroupType();
        $attributeGroupType
            ->setName($name)
            ->setTypes($types);

        $add = new Add();
        $add->setAttributeGroupType($attributeGroupType);

        $this->setAdd($add);
    }

    /**
     * @param Add $add
     * @return AttributeGroup
     */
    public function setAdd(Add $add)
    {
        $this->add = $add;

        return $this;
    }

    /**
     * @return Add
     */
    public function getAdd()
    {
        return $this->add;
    }
}
