<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Delete;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Delete
 */
class Factory
{
    /**
     *
     * @var array
     */
    protected $facSetter;

    /**
     *
     * @return Request
     */
    public function request()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Request();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return ObjectWs\Credentials
     */
    public function credentials()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ObjectWs\Credentials();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return AttributeGroup
     */
    public function attributeGroup()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new AttributeGroup();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return Delete
     */
    public function delete()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Delete();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return AttributeGroupType
     */
    public function attributeGroupType()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new AttributeGroupType();
        }
        return $this->facSetter[__FUNCTION__];
    }
}
