<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Show
 *
 * @Serializer\XmlRoot("Show")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Show
 */
class Show
{

    /**
     * @Serializer\SerializedName("AttributeGroupType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Show\AttributeGroupType")
     * @var AttributeGroupType
     */
    protected $attributeGroupType;

    /**
     * @return AttributeGroupType
     */
    public function getAttributeGroupType()
    {
        return $this->attributeGroupType;
    }

    /**
     * @param AttributeGroupType $attributeGroupType
     * @return Show
     */
    public function setAttributeGroupType($attributeGroupType)
    {
        $this->attributeGroupType = $attributeGroupType;
        return $this;
    }

}
