<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Update;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class AttributeGroup
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Update
 */
class AttributeGroup
{
    /**
     * @Serializer\SerializedName("Update")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Update\Update")
     * @var Update
     */
    private $update;

    /**
     * @param string $id
     * @param string $name
     * @param string[]|ArrayCollection $addTypeIds
     * @param string[]|ArrayCollection $deleteTypeIds
     * @param boolean $deleteReferences
     */
    public function setAttributeGroupData(
        $id,
        $name,
        $addTypeIds,
        $deleteTypeIds,
        $deleteReferences = false
    ) {
        $update = new Update();
        $attributeGroupType = new AttributeGroupType();
        $addType = new AddType();
        $deleteType = new DeleteType();

        $attributeGroupType
            ->setId($id)
            ->setName($name);

        if (!empty($addTypeIds) && !$addTypeIds->isEmpty()) {
            foreach ($addTypeIds as $typeId) {
                $addType->addTypeId($typeId);
            }

            $attributeGroupType->setAddType($addType);
        }

        if (!empty($deleteTypeIds) && !$deleteTypeIds->isEmpty()) {
            foreach ($deleteTypeIds as $typeId) {
                $deleteType->addTypeId($typeId);
            }

            $attributeGroupType->setDeleteType($deleteType);
        }

        if ($deleteReferences === true) {
            $attributeGroupType->setDeleteReferences($deleteReferences);
        }

        $update->setAttributeGroupType($attributeGroupType);
        $this->setUpdate($update);
    }

    /**
     * @return Update
     */
    public function getUpdate()
    {
        return $this->update;
    }

    /**
     * @param Update $update
     */
    public function setUpdate(Update $update)
    {
        $this->update = $update;
    }
}
