<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Update;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class DeleteType
 *
 * @Serializer\XmlRoot("AttributeGroupType")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Update
 */
class DeleteType
{
    /**
     * @Serializer\SerializedName("DeleteTypes")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(entry="TypeId", inline=true)
     *
     * @var string[]|ArrayCollection
     */
    private $typeIds;

    /**
     * @return string[]|ArrayCollection
     */
    public function getTypeIds()
    {
        return $this->typeIds;
    }

    /**
     * @param string $typeId
     *
     * @return $this
     */
    public function addTypeId($typeId)
    {
        if (!$this->typeIds) {
            $this->typeIds = new ArrayCollection();
        }

        if (!$this->typeIds->contains($typeId)) {
            $this->typeIds->add($typeId);
        }

        return $this;
    }
}
