<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Object
 *
 * @Serializer\XmlRoot("Credentials")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Delete
 */
class Object
{

    /**
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Delete\Delete")
     * @var Delete
     */
    protected $delete;

    /**
     * @return Delete
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * @param Delete $delete
     * @return Object
     */
    public function setDelete(Delete $delete)
    {
        $this->delete = $delete;
        return $this;
    }

    /**
     * @param string $guid
     * @param string $referenceId
     */
    public function setObjectTypeData($guid, $referenceId)
    {
        $objectType = new ObjectType();

        if (null !== $guid) {
            $objectType->setGuid($guid);
        }
        if (null !== $referenceId) {
            $objectType->setReferenceId($referenceId);
        }

        $delete = new Delete();
        $delete->setObjectType($objectType);
        $this->setDelete($delete);
    }

}
