<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Show\Multi;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Object
 *
 * @Serializer\XmlRoot("Credentials")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Show\Multi
 */
class Object
{
    /**
     * @Serializer\SerializedName("ShowMulti")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Show\Multi\Show")
     * @var Show
     */
    protected $show;

    /**
     * @param Show $show
     */
    public function setShow(Show $show)
    {
        $this->show = $show;
    }

    /**
     * @return Show
     */
    public function getShow()
    {
        return $this->show;
    }

    /**
     * @param string $guid
     * @param int $offset
     * @param int $limit
     */
    public function setObjectTypeData($guid, $referenceId, $offset, $limit)
    {
        $objectType = new ObjectType();
        if ($guid != null) {
            $objectType->setGuid($guid);
        }
        if ($referenceId != null) {
            $objectType->setReferenceId($referenceId);
        }
        $objectType->setOffset($offset);
        $objectType->setLimit($limit);

        $show = new Show();
        $show->setObjectType($objectType);
        $this->setShow($show);
    }

}
