<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Update;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Update
 *
 * @package Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Update
 * @Serializer\XmlRoot("Update")
 */
class Update
{
    /**
     * @Serializer\SerializedName("ObjectType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Update\ObjectType")
     *
     * @var ObjectType
     */
    private $objectType;

    /**
     *
     * @param ObjectType $objectType
     */
    public function setObjectType(ObjectType $objectType)
    {
        $this->objectType = $objectType;
    }

    /**
     *
     * @return ObjectType
     */
    public function getObjectType()
    {
        return $this->objectType;
    }
}
