<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Add\ObjectTypeAdd;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("Add")
 */
class Add
{

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    protected $status;

    /**
     * @Serializer\SerializedName("Count")
     * @Serializer\Type("string")
     * @var string
     */
    protected $count;

    /**
     * @Serializer\SerializedName("TypeType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Add\ObjectTypeAdd\TypeType")
     * @var TypeType
     */
    protected $objectType;

    /**
     * @param TypeType $objectType
     */
    public function setObjectType(TypeType $objectType)
    {
        $this->objectType = $objectType;
    }

    /**
     * @return TypeType
     */
    public function getObjectType()
    {
        return $this->objectType;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param string $count
     */
    public function setCount($count)
    {
        $this->count = $count;
    }

}
