<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Add\ObjectTypeAdd;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs;

/**
 * Class Factory
 * @package Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Add\ObjectTypeAdd
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return Request
     */
    public function request()
    {
        if (!isset($this->facSetter['request'])) {
            $this->facSetter['request'] = new Request();
        }
        return $this->facSetter['request'];
    }

    /**
     * @return ObjectWs\Credentials
     */
    public function credentials()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ObjectWs\Credentials();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Object
     */
    public function object()
    {
        if (!isset($this->facSetter['object'])) {
            $this->facSetter['object'] = new Object();
        }
        return $this->facSetter['object'];
    }

    /**
     * @return Add
     */
    public function add()
    {
        if (!isset($this->facSetter['add'])) {
            $this->facSetter['add'] = new Add();
        }
        return $this->facSetter['add'];
    }

    /**
     * @return ObjectType
     */
    public function objectType()
    {
        if (!isset($this->facSetter['objectType'])) {
            $this->facSetter['objectType'] = new ObjectType();
        }
        return $this->facSetter['objectType'];
    }
}
