<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Update\ObjectTypeUpdate;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ObjectType
 *
 * @Serializer\XmlRoot("Credentials")
 * @package Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Update\ObjectTypeUpdate
 */
class ObjectType
{

    /**
     * @Serializer\SerializedName("Update")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Update\ObjectTypeUpdate\Update")
     * @var Update
     */
    protected $update;

    /**
     *
     * @param Update $update
     */
    public function setUpdate(Update $update)
    {
        $this->update = $update;
    }

    /**
     *
     * @return Update
     */
    public function getUpdate()
    {
        return $this->update;
    }

    /**
     *
     * @param $id
     * @param string $name
     * @param string $order
     */
    public function setObjectTypeData($id, $name, $order)
    {
        $objectType = new TypeType();
        $objectType->setId($id);
        $objectType->setName($name);
        $objectType->setOrder($order);

        $update = new Update();
        $update->setObjectType($objectType);
        $this->setUpdate($update);
    }

}
