<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Update\ObjectTypeUpdate;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs\Credentials;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("SsoRequest")
 * @package Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Update\ObjectTypeUpdate
 */
class Request
{
    /**
     * @Serializer\SerializedName("Credentials")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs\Credentials")
     * @var Credentials
     */
    protected $credentials;

    /**
     * @Serializer\SerializedName("Type")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Update\ObjectTypeUpdate\ObjectType")
     * @var ObjectType
     */
    protected $objectType;

    /**
     *
     * @param Credentials $credentials
     */
    public function setCredentials(Credentials $credentials)
    {
        $this->credentials = $credentials;
    }

    /**
     *
     * @return Credentials
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    /**
     *
     * @param ObjectType $objectType
     */
    public function setObjectType(ObjectType $objectType)
    {
        $this->objectType = $objectType;
    }

    /**
     *
     * @return ObjectType
     */
    public function getObjectType()
    {
        return $this->objectType;
    }
}
