<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Add\ObjectValueAdd;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Add
 *
 * @Serializer\XmlRoot("Add")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Add\ObjectValueAdd
 */
class Add
{

    /**
     * @Serializer\SerializedName("ObjectValueType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Add\ObjectValueAdd\ObjectValueType")
     * @var ObjectValueType
     */
    protected $objectValueType;

    /**
     * @param ObjectValueType $objectValueType
     */
    public function setObjectValueType(ObjectValueType $objectValueType)
    {
        $this->objectValueType = $objectValueType;
    }

    /**
     * @return ObjectValueType
     */
    public function getObjectValueType()
    {
        return $this->objectValueType;
    }

}
