<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Add\ObjectValueAdd;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class ObjectValueType
 *
 * @Serializer\XmlRoot("Add")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Add\ObjectValueAdd
 */
class ObjectValueType
{
    /**
     * @Serializer\SerializedName("ObjectGuid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $objectGuid;

    /**
     * @Serializer\SerializedName("ObjectValue")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $objectValue;

    /**
     * @Serializer\SerializedName("LanguageCode")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $languageCode;

    /**
     * @Serializer\SerializedName("AttributeId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $attributeId;

    /**
     * @return string
     */
    public function getObjectGuid()
    {
        return $this->objectGuid;
    }

    /**
     * @param string $objectGuid
     * @return ObjectValueType
     */
    public function setObjectGuid($objectGuid)
    {
        $this->objectGuid = $objectGuid;
        return $this;
    }

    /**
     * @return string
     */
    public function getObjectValue()
    {
        return $this->objectValue;
    }

    /**
     * @param string $objectValue
     * @return ObjectValueType
     */
    public function setObjectValue($objectValue)
    {
        $this->objectValue = $objectValue;
        return $this;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }

    /**
     * @param string $languageCode
     * @return ObjectValueType
     */
    public function setLanguageCode($languageCode)
    {
        $this->languageCode = $languageCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeId()
    {
        return $this->attributeId;
    }

    /**
     * @param string $attributeId
     * @return ObjectValueType
     */
    public function setAttributeId($attributeId)
    {
        $this->attributeId = $attributeId;
        return $this;
    }
}
