<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Update;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ObjectValue
 *
 * @Serializer\XmlRoot("Credentials")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Update
 */
class ObjectValue
{
    /**
     * @Serializer\SerializedName("Update")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Update\Update")
     * @var Update
     */
    private $update;

    /**
     * @param string $id
     * @param string|null $value
     * @param string|null $languageCode
     */
    public function setObjectValue($id, $value = null, $languageCode = null)
    {
        $objectValueType = new ObjectValueType();
        $objectValueType
            ->setId($id)
            ->setValue($value)
            ->setLanguageCode($languageCode);

        $update = new Update();
        $update->setObjectValueType($objectValueType);
        $this->setUpdate($update);
    }

    /**
     * @return Update
     */
    public function getUpdate()
    {
        return $this->update;
    }

    /**
     * @param Update $update
     * @return ObjectValue
     */
    public function setUpdate(Update $update)
    {
        $this->update = $update;

        return $this;
    }
}
