<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\Application\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Add
 *
 * @Serializer\XmlRoot("Application")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\Application\Add
 */
class Add
{
    /**
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\Application\Add\Value")
     * @var Value
     */
    private $value;

    /**
     * @return Value
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param Value $value
     * @return Add
     */
    public function setValue(Value $value)
    {
        $this->value = $value;

        return $this;
    }
}
