<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\Application\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Attribute
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\Application\Add
 */
class Application
{
    /**
     * @Serializer\SerializedName("Add")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\Application\Add\Add")
     * @var Add
     */
    private $add;

    /**
     * @param string $name
     * @param string $description
     */
    public function setApplication($name, $description)
    {
        $applicationType = new ApplicationType();
        $applicationType
            ->setName($name)
            ->setDescription($description);

        $value = new Value();
        $value->setApplicationType($applicationType);

        $add = new Add();
        $add->setValue($value);

        $this->setAdd($add);
    }

    /**
     * @return Add
     */
    public function getAdd()
    {
        return $this->add;
    }

    /**
     * @param Add $add
     * @return Application
     */
    public function setAdd(Add $add)
    {
        $this->add = $add;

        return $this;
    }
}
