<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("ApplicationAttribute")
 *
 * Class ApplicationAttribute
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Add
 */
class ApplicationAttribute
{
    /**
     * @Serializer\SerializedName("Add")
     * @Serializer\Type(" Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Add\Add")
     *
     * @var Add
     */
    private $add;

    /**
     * @param string $applicationName
     * @param string $name
     * @param string $type
     */
    public function setApplicationAttribute(
        $applicationName,
        $name,
        $type
    ) {
        $applicationType = new ApplicationType();
        $applicationType->setName($applicationName);

        $attributeType = new AttributeType();
        $attributeType->setName($name)->setType($type);

        $key = new Key();
        $value = new Value();
        $add = new Add();

        $value->setAttributeType($attributeType);
        $add->setValue($value);

        $key->setApplicationType($applicationType);
        $add->setKey($key);

        $this->setAdd($add);
    }

    /**
     * @return Add
     */
    public function getAdd()
    {
        return $this->add;
    }

    /**
     * @param Add $add
     * @return ApplicationAttribute
     */
    public function setAdd(Add $add)
    {
        $this->add = $add;

        return $this;
    }
}
