<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("AttributeType")
 *
 * Class AttributeType
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Add
 */
class AttributeType
{
    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Type")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $type;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return AttributeType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return AttributeType
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }
}
