<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("Value")
 *
 * Class Value
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Add
 */
class Value
{
    /**
     * @Serializer\SerializedName("AttributeType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Add\AttributeType")
     *
     * @var AttributeType
     */
    private $attributeType;

    /**
     * @return AttributeType
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }

    /**
     * @param AttributeType $attributeType
     * @return Value
     */
    public function setAttributeType(AttributeType $attributeType)
    {
        $this->attributeType = $attributeType;

        return $this;
    }
}
