<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ApplicationAttribute
 *
 * @Serializer\XmlRoot("ApplicationAttribute")
 *
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Delete
 */
class ApplicationAttribute
{
    /**
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Delete\Delete")
     *
     * @var Delete
     */
    private $delete;

    /**
     * @param string $applicationName
     * @param string $attributeName
     */
    public function setApplicationAttribute(
        $applicationName,
        $attributeName
    ) {
        $applicationType = new ApplicationType();
        $applicationType->setName($applicationName);

        $attributeType = new AttributeType();
        $attributeType->setName($attributeName);

        $delete = new Delete();
        $key = new Key();

        $key->setApplicationType($applicationType);
        $key->setAttributeType($attributeType);
        $delete->setKey($key);

        $this->setDelete($delete);
    }

    /**
     * @return Delete
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * @param Delete $delete
     * @return ApplicationAttribute
     */
    public function setDelete(Delete $delete)
    {
        $this->delete = $delete;

        return $this;
    }
}
