<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Delete;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("SsoRequest")
 *
 * Class Request
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Delete
 */
class Request
{
    /**
     * @Serializer\SerializedName("Credentials")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials")
     *
     * @var Credentials
     */
    private $credentials;

    /**
     * @Serializer\SerializedName("ApplicationAttribute")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Delete\ApplicationAttribute")
     *
     * @var ApplicationAttribute
     */
    private $applicationAttribute;

    /**
     * @param Credentials $credentials
     */
    public function setCredentials(Credentials $credentials)
    {
        $this->credentials = $credentials;
    }

    /**
     * @return Credentials
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    /**
     * @param ApplicationAttribute $applicationAttribute
     */
    public function setApplicationAttribute(ApplicationAttribute $applicationAttribute)
    {
        $this->applicationAttribute = $applicationAttribute;
    }

    /**
     * @return ApplicationAttribute
     */
    public function getApplicationAttribute()
    {
        return $this->applicationAttribute;
    }
}
