<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("ApplicationAttribute")
 *
 * Class ApplicationAttribute
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Show
 */
class ApplicationAttribute
{
    /**
     * @Serializer\SerializedName("Show")
     * @Serializer\Type(" Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationAttribute\Show\Show")
     *
     * @var Show
     */
    private $show;

    /**
     * @param string $applicationName
     * @param string $attributeName
     */
    public function setApplicationAttribute(
        $applicationName,
        $attributeName
    ) {
        $applicationType = new ApplicationType();
        $applicationType->setName($applicationName);

        $attributeType = new AttributeType();
        $attributeType->setName($attributeName);

        $key = new Key();
        $show = new Show();

        $key->setApplicationType($applicationType);
        $key->setAttributeType($attributeType);
        $show->setKey($key);

        $this->setShow($show);
    }

    /**
     * @return Show
     */
    public function getShow()
    {
        return $this->show;
    }

    /**
     * @param Show $show
     * @return ApplicationAttribute
     */
    public function setShow($show)
    {
        $this->show = $show;

        return $this;
    }
}
