<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationRole\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("ApplicationRole")
 *
 * Class ApplicationAttribute
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationRole\Delete
 */
class ApplicationRole
{
    /**
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type(" Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationRole\Delete\Delete")
     *
     * @var Delete
     */
    private $delete;

    /**
     * @param string $applicationName
     * @param string $name
     */
    public function setApplicationRole(
        $applicationName,
        $name
    ) {
        $applicationType = new ApplicationType();
        $applicationType->setName($applicationName);

        $roleType = new RoleType();
        $roleType->setName($name);

        $key = new Key();
        $delete = new Delete();

        $key->setApplicationType($applicationType);
        $key->setRoleType($roleType);
        $delete->setKey($key);

        $this->setDelete($delete);
    }

    /**
     * @return Delete
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * @param Delete $delete
     * @return ApplicationRole
     */
    public function setDelete(Delete $delete)
    {
        $this->delete = $delete;

        return $this;
    }
}
