<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\Attribute\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Attribute
 *
 * @Serializer\XmlRoot("Credentials")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\Attribute\Add
 */
class Attribute
{
    /**
     * @Serializer\SerializedName("Add")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\Attribute\Add\Add")
     *
     * @var Add
     */
    protected $add;

    /**
     * @param Add $add
     */
    public function setAdd(Add $add)
    {
        $this->add = $add;
    }

    /**
     * @return Add
     */
    public function getAdd()
    {
        return $this->add;
    }

    public function setAttributeData($attributeName, $attributeGroupId)
    {
        $attributeType = new AttributeType();
        $attributeType
            ->setAttributeName($attributeName)
            ->setAttributeGroupId($attributeGroupId);

        $add = new Add();
        $add->setAttributeType($attributeType);
        $this->setAdd($add);
    }
}
