<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\Attribute\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Attribute
 *
 * @Serializer\XmlRoot("Credentials")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\Attribute\Delete
 */
class Attribute
{
    /**
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\Attribute\Delete\Delete")
     * @var Delete
     */
    protected $delete;

    /**
     * @return Delete
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * @param Delete $delete
     * @return Attribute
     */
    public function setDelete(Delete $delete)
    {
        $this->delete = $delete;
        return $this;
    }

    /**
     * @param string $attrGroupId
     * @param boolean $deleteReferences
     */
    public function setAttributeTypeData($attrGroupId, $deleteReferences)
    {
        $attributeType = new AttributeType();
        $attributeType->setId($attrGroupId);
        if (null !== $deleteReferences) {
            $attributeType->setDeleteReferences($deleteReferences);
        }

        $delete = new Delete();
        $delete->setAttributeType($attributeType);
        $this->setDelete($delete);
    }
}
