<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\Attribute\Delete;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs\Credentials;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("SsoRequest")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\Attribute\Delete
 */
class Request
{
    /**
     * @Serializer\SerializedName("Credentials")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs\Credentials")
     *
     * @var Credentials
     */
    protected $credentials;

    /**
     * @Serializer\SerializedName("Attribute")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\Attribute\Delete\Attribute")
     *
     * @var Attribute
     */
    protected $attribute;

    /**
     * @param Credentials $credentials
     */
    public function setCredentials(Credentials $credentials)
    {
        $this->credentials = $credentials;
    }

    /**
     * @return Credentials
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    /**
     * @param Attribute $attribute
     */
    public function setAttribute(Attribute $attribute)
    {
        $this->attribute = $attribute;
    }

    /**
     * @return Attribute
     */
    public function getAttribute()
    {
        return $this->attribute;
    }
}
