<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("Key")
 *
 * Class Value
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Delete
 */
class Key
{
    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Delete\UserType")
     *
     * @var UserType
     */
    protected $userType;

    /**
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType $userType
     * @return $this
     */
    public function setUserType(UserType $userType)
    {
        $this->userType = $userType;

        return $this;
    }
}
