<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Show;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Show
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return Request
     */
    public function request()
    {
        return new Request();
    }

    /**
     * @return UserWs\Credentials
     */
    public function credentials()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserWs\Credentials();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @param $identifier
     * @return User
     */
    public function user($identifier)
    {
        return new User($identifier);
    }

    /**
     * @return Show
     */
    public function show()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Show();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Key
     */
    public function key()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Key();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserType
     */
    public function userType()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserType();
        }
        return $this->facSetter[__FUNCTION__];
    }
}
